/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.quickhomes;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;

@Mod(value="quickhomes")
@Mod.EventBusSubscriber(modid="quickhomes")
public class QuickHomesMod {
    public static final String MOD_ID = "quickhomes";
    private static ServerConfig SERVER_CONFIG = null;
    private static ForgeConfigSpec SERVER_CONFIG_SPEC = null;

    public QuickHomesMod() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::loadComplete);
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_CONFIG_SPEC = (ForgeConfigSpec)specPair.getRight();
        SERVER_CONFIG = (ServerConfig)specPair.getLeft();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, SERVER_CONFIG_SPEC);
    }

    @SubscribeEvent
    public static void onServerStarting(FMLServerStartingEvent event) {
        CommandDispatcher d = event.getServer().func_195571_aL().func_197054_a();
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"home").requires(source -> {
            try {
                return source.func_197035_h() != null;
            }
            catch (CommandSyntaxException e) {
                return false;
            }
        })).executes(command -> {
            ServerPlayerEntity player = ((CommandSource)command.getSource()).func_197035_h();
            CompoundNBT playerD = player.getPersistentData();
            if (playerD.func_150297_b(MOD_ID, 10)) {
                CompoundNBT data = playerD.func_74775_l(MOD_ID);
                double posX = data.func_74769_h("x");
                double posY = data.func_74769_h("y");
                double posZ = data.func_74769_h("z");
                String dim = data.func_74779_i("dim");
                player.func_200619_a(player.func_184102_h().func_71218_a(RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(dim))), posX, posY, posZ, player.field_70177_z, player.field_70125_A);
                return 1;
            }
            player.func_145747_a((ITextComponent)new StringTextComponent("No home set."), Util.field_240973_b_);
            return 0;
        }));
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"sethome").requires(source -> {
            try {
                return source.func_197035_h() != null;
            }
            catch (CommandSyntaxException e) {
                return false;
            }
        })).executes(command -> {
            ServerPlayerEntity player = ((CommandSource)command.getSource()).func_197035_h();
            CompoundNBT playerD = player.getPersistentData();
            CompoundNBT data = new CompoundNBT();
            data.func_74780_a("x", player.func_226277_ct_());
            data.func_74780_a("y", player.func_226278_cu_());
            data.func_74780_a("z", player.func_226281_cx_());
            data.func_74778_a("dim", player.func_130014_f_().func_234923_W_().func_240901_a_().toString());
            playerD.func_218657_a(MOD_ID, (INBT)data);
            player.func_145747_a((ITextComponent)new StringTextComponent("Home set."), Util.field_240973_b_);
            return 1;
        }));
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        if (!player.field_70170_p.field_72995_K && ((Boolean)QuickHomesMod.SERVER_CONFIG.joinMessageEnabled.get()).booleanValue()) {
            player.func_145747_a((ITextComponent)new StringTextComponent("This server is running QuickHomes " + ((ModContainer)ModList.get().getModContainerById(MOD_ID).get()).getModInfo().getVersion() + " by its_meow!"), Util.field_240973_b_);
            player.func_145747_a((ITextComponent)new StringTextComponent("You can use /sethome and /home with this mod installed."), Util.field_240973_b_);
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        CompoundNBT oldData = event.getOriginal().getPersistentData();
        if (oldData.func_150297_b(MOD_ID, 10)) {
            event.getPlayer().getPersistentData().func_218657_a(MOD_ID, (INBT)oldData.func_74775_l(MOD_ID));
        }
    }

    public static class ServerConfig {
        public ForgeConfigSpec.Builder builder;
        public final ForgeConfigSpec.BooleanValue joinMessageEnabled;

        ServerConfig(ForgeConfigSpec.Builder builder) {
            this.builder = builder;
            this.joinMessageEnabled = builder.comment("Set to false to disable join message. Place a copy of this config in the defaultconfigs/ folder in the main server/.minecraft directory (or make the folder if it's not there) to copy this to new worlds.").worldRestart().define("enable_join_message", true);
            builder.build();
        }
    }
}

